using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

using RJH.Utils.WebDownload;

namespace RJH.Utils.WebDownload.Tester
{
	/// <summary>
	/// Summary description for WebDownloadForm.
	/// </summary>
	public class WebDownloadForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.TextBox downloadUrlTextBox;
		private System.Windows.Forms.Label urlLabel;
		private System.Windows.Forms.GroupBox outputGroupBox;
		private System.Windows.Forms.Button downloadBtn;
		private System.Windows.Forms.Label downloadProgressLbl;
		private System.Windows.Forms.Label bytesDownloadedLbl;
		private System.Windows.Forms.Label totalBytesLbl;
		private System.Windows.Forms.TextBox bytesDownloadedTextBox;
		private System.Windows.Forms.TextBox totalBytesTextBox;
		private System.Windows.Forms.ProgressBar progressBar;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public WebDownloadForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.downloadUrlTextBox = new System.Windows.Forms.TextBox();
			this.urlLabel = new System.Windows.Forms.Label();
			this.outputGroupBox = new System.Windows.Forms.GroupBox();
			this.downloadBtn = new System.Windows.Forms.Button();
			this.progressBar = new System.Windows.Forms.ProgressBar();
			this.downloadProgressLbl = new System.Windows.Forms.Label();
			this.bytesDownloadedLbl = new System.Windows.Forms.Label();
			this.totalBytesLbl = new System.Windows.Forms.Label();
			this.bytesDownloadedTextBox = new System.Windows.Forms.TextBox();
			this.totalBytesTextBox = new System.Windows.Forms.TextBox();
			this.outputGroupBox.SuspendLayout();
			this.SuspendLayout();
			// 
			// downloadUrlTextBox
			// 
			this.downloadUrlTextBox.Location = new System.Drawing.Point(128, 16);
			this.downloadUrlTextBox.Name = "downloadUrlTextBox";
			this.downloadUrlTextBox.Size = new System.Drawing.Size(280, 20);
			this.downloadUrlTextBox.TabIndex = 0;
			this.downloadUrlTextBox.Text = "";
			// 
			// urlLabel
			// 
			this.urlLabel.Location = new System.Drawing.Point(16, 20);
			this.urlLabel.Name = "urlLabel";
			this.urlLabel.Size = new System.Drawing.Size(100, 16);
			this.urlLabel.TabIndex = 1;
			this.urlLabel.Text = "File To Download :";
			// 
			// outputGroupBox
			// 
			this.outputGroupBox.Controls.AddRange(new System.Windows.Forms.Control[] {
																												 this.totalBytesTextBox,
																												 this.bytesDownloadedTextBox,
																												 this.bytesDownloadedLbl,
																												 this.downloadProgressLbl,
																												 this.progressBar,
																												 this.totalBytesLbl});
			this.outputGroupBox.Enabled = false;
			this.outputGroupBox.Location = new System.Drawing.Point(8, 48);
			this.outputGroupBox.Name = "outputGroupBox";
			this.outputGroupBox.Size = new System.Drawing.Size(504, 120);
			this.outputGroupBox.TabIndex = 2;
			this.outputGroupBox.TabStop = false;
			this.outputGroupBox.Text = "Output and Callbacks";
			// 
			// downloadBtn
			// 
			this.downloadBtn.Location = new System.Drawing.Point(416, 16);
			this.downloadBtn.Name = "downloadBtn";
			this.downloadBtn.Size = new System.Drawing.Size(88, 23);
			this.downloadBtn.TabIndex = 3;
			this.downloadBtn.Text = "Download";
			this.downloadBtn.Click += new System.EventHandler(this.downloadBtn_Click);
			// 
			// progressBar
			// 
			this.progressBar.Location = new System.Drawing.Point(120, 88);
			this.progressBar.Name = "progressBar";
			this.progressBar.Size = new System.Drawing.Size(376, 23);
			this.progressBar.TabIndex = 0;
			// 
			// downloadProgressLbl
			// 
			this.downloadProgressLbl.Location = new System.Drawing.Point(16, 88);
			this.downloadProgressLbl.Name = "downloadProgressLbl";
			this.downloadProgressLbl.Size = new System.Drawing.Size(104, 23);
			this.downloadProgressLbl.TabIndex = 1;
			this.downloadProgressLbl.Text = "Download Progress";
			// 
			// bytesDownloadedLbl
			// 
			this.bytesDownloadedLbl.Location = new System.Drawing.Point(16, 28);
			this.bytesDownloadedLbl.Name = "bytesDownloadedLbl";
			this.bytesDownloadedLbl.TabIndex = 2;
			this.bytesDownloadedLbl.Text = "Bytes Downloaded";
			// 
			// totalBytesLbl
			// 
			this.totalBytesLbl.Location = new System.Drawing.Point(16, 60);
			this.totalBytesLbl.Name = "totalBytesLbl";
			this.totalBytesLbl.TabIndex = 2;
			this.totalBytesLbl.Text = "Total Bytes";
			// 
			// bytesDownloadedTextBox
			// 
			this.bytesDownloadedTextBox.Location = new System.Drawing.Point(120, 24);
			this.bytesDownloadedTextBox.Name = "bytesDownloadedTextBox";
			this.bytesDownloadedTextBox.ReadOnly = true;
			this.bytesDownloadedTextBox.Size = new System.Drawing.Size(168, 20);
			this.bytesDownloadedTextBox.TabIndex = 3;
			this.bytesDownloadedTextBox.Text = "";
			this.bytesDownloadedTextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			// 
			// totalBytesTextBox
			// 
			this.totalBytesTextBox.Location = new System.Drawing.Point(120, 56);
			this.totalBytesTextBox.Name = "totalBytesTextBox";
			this.totalBytesTextBox.ReadOnly = true;
			this.totalBytesTextBox.Size = new System.Drawing.Size(168, 20);
			this.totalBytesTextBox.TabIndex = 4;
			this.totalBytesTextBox.Text = "";
			this.totalBytesTextBox.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			// 
			// WebDownloadForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(520, 175);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																							 this.downloadBtn,
																							 this.outputGroupBox,
																							 this.urlLabel,
																							 this.downloadUrlTextBox});
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.Name = "WebDownloadForm";
			this.Text = "WebDownload Tester";
			this.outputGroupBox.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		[STAThread]
		static void Main()
		{
			Application.Run(new WebDownloadForm());
		}

		private void DownloadProgressCallback ( int bytesSoFar, int totalBytes )
		{
			bytesDownloadedTextBox.Text = bytesSoFar.ToString("#,##0");

			if ( totalBytes != -1 )
			{
				progressBar.Minimum = 0;
				progressBar.Maximum = totalBytes;
				progressBar.Value = bytesSoFar;
				totalBytesTextBox.Text = totalBytes.ToString("#,##0");
			}
			else
			{
				progressBar.Visible = false;
				totalBytesTextBox.Text = "Total File Size Not Known";
			}
		}

		private void DownloadCompleteCallback ( byte[] dataDownloaded )
		{
			if ( !progressBar.Visible )
			{
				progressBar.Visible = true;
				progressBar.Minimum = 0;
				progressBar.Value = progressBar.Maximum = 1;
				totalBytesTextBox.Text = bytesDownloadedTextBox.Text;
			}

			MessageBox.Show("Download complete...", "Download Info" );
		}

		private void downloadBtn_Click(object sender, System.EventArgs e)
		{
			if ( this.downloadUrlTextBox.Text != "" )
			{
				this.outputGroupBox.Enabled = true;

				this.bytesDownloadedTextBox.Text = "";
				this.totalBytesTextBox.Text = "";
				this.progressBar.Minimum = 0;
				this.progressBar.Maximum = 0;
				this.progressBar.Value = 0;


				DownloadThread dl = new DownloadThread();
				dl.DownloadUrl = this.downloadUrlTextBox.Text;
				dl.CompleteCallback += new DownloadCompleteHandler( DownloadCompleteCallback );
				dl.ProgressCallback += new DownloadProgressHandler( DownloadProgressCallback );

				System.Threading.Thread t = new System.Threading.Thread( 
					new System.Threading.ThreadStart(
					dl.Download ));
				t.Start();
			}
		}
	}
}
